/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id: AnimActionEditorPropertiesPanel.cpp,v 1.1 2008/11/17 12:49:32 PauloZaffari Exp wwwrun $
$DateTime$
Description:  This is the source file for the module AnimactionEditorPropertiesPanel. 
The AnimactionEditorPropertiesPanel is a panel containing a XTP taskbar for the 
common Properties over the AnimAction editor.
-------------------------------------------------------------------------
History:
- 17:11:2008   12:49 : Created by Paulo Zaffari
*************************************************************************/

#include "stdafx.h"

#include "..\PropertiesPanel.h"
#include "AnimActionEditorPropertiesPanel.h"

#include "IAnimAction.h"

#include "AnimAction Editor/Support/EditorAnimActionManager.h"

BEGIN_MESSAGE_MAP(CAnimActionEditorPropertiesPanel, CXTResizeDialog)
	ON_WM_CLOSE()
	ON_MESSAGE(					XTPWM_TASKPANEL_NOTIFY			, &CAnimActionEditorPropertiesPanel::OnTaskPanelNotify)
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////
CAnimActionEditorPropertiesPanel::CAnimActionEditorPropertiesPanel(CWnd* pParent)
:CXTResizeDialog(CAnimActionEditorPropertiesPanel::IDD, pParent)
{
	Create( IDD,pParent );
	m_wndTaskPanel.SetOwner(this);
}
//////////////////////////////////////////////////////////////////////////
CAnimActionEditorPropertiesPanel::~CAnimActionEditorPropertiesPanel()
{

}
//////////////////////////////////////////////////////////////////////////
void CAnimActionEditorPropertiesPanel::OnNotifySelectionChange(CAnimActionEditorDialog::TDAnimActionPrototypes& rcAnimActionPrototypes)
{
	IVariable::EDataType																	eDataType(IVariable::DT_SIMPLE);
	IAnimActionClass																			*piCurrentAnimAction(NULL);

	// Those two are for checking if all the items are from the same AnimAction class.
	size_t																								nTotalSelectedItems(0);
	size_t																								nCurrentSelectedItem(0);

	CVarBlock*																						poCurrentVarBlock(NULL);

	const SAnimActionPropertyDesc*												astPropertiesDesc(NULL);
	CVariableBase																					*poVariable(NULL);
	int																										nCurrentPropertyIndex(0);

	const char*																						szClassName(NULL);

	// We first make sure our Varblock has no variables in it,
	// this way we won't have the same information added multiple times
	// nor outdated information....
	poCurrentVarBlock=m_oVarObject.GetVarBlock();
	if (poCurrentVarBlock)
	{
		// Inside the VarBlock the variables are stored into SmartPointers...
		// ... for this reason, we don't need to explictly dealocate them here...
		//... even having allocated them dynamically.
		// When we call clear, the smart pointers will delete all we need for us.
		poCurrentVarBlock->Clear();
	}

	// We also remove all properties from the display so it won't be displaying
	// old info, no matter what.
	m_poPropertiesPanel->DeleteVars();

	// We will also disable the window until we get some valid properties in it.
	m_poPropertiesPanel->EnableWindow(FALSE);

	// If we have no items selected, there is no point in trying to add properties
	// to the panel...
	if (rcAnimActionPrototypes.size()==0)
	{
		return;
	}

	// Here we check which properties are common to all selected objects.
	// The algorithm used takes the first element as the property model
	// and from it check if the next ones have ALL the same properties.
	// In case a new element has not any of the model properties, it will
	// not be shown in the properties control.
	szClassName=rcAnimActionPrototypes[0]->GetAAClassName();


	// If either any of the other selected elements is not a prototype nor a prototype of the same
	// class, we won't display properties.
	nTotalSelectedItems=rcAnimActionPrototypes.size();
	for (nCurrentSelectedItem=0;nCurrentSelectedItem<nTotalSelectedItems;++nCurrentSelectedItem)
	{
		if (stricmp(szClassName,rcAnimActionPrototypes[0]->GetAAClassName())!=0)
		{
			return;
		}
	}

	// As all the elements are prototypes from the same AnimAction class, all of them have the same
	// properties and this we just need to analyze one of them in order to know what are all the 
	// properties we have to display...
	// Setting property values, on the other hand, may require us to iterate over all the selected
	// elements checking their values for a given property. If equals, start the property with the 
	// appropriate value, if they have different values, leave the field blank.
	piCurrentAnimAction=(IAnimActionClass*)rcAnimActionPrototypes[0];

	// We are getting the property values as well in order to set the values of the added variables.
	// BUG: currently the values displayed are the ones from the first AnimAction selected only.
	// It should check with all variables those who have the same value and only set those.
	TAnimActionPropertyValues&		rcPropertyValues=piCurrentAnimAction->GetProperties();

	// We will be using the properties description for displaying the properties properly in the
	// properties control.
	astPropertiesDesc=piCurrentAnimAction->GetPropertiesDesc();

	// In this case we have no property descriptors at all...(which means we don't have properties as well)
	if (!astPropertiesDesc)
	{
		//... we still can't add properties here as we don't actually have them...
		return;
	}

	// For all valid descriptors (before the null descriptor is found)...
	for (
		nCurrentPropertyIndex=0;
		astPropertiesDesc[nCurrentPropertyIndex].propertyType!=eAAPT_null;
	++nCurrentPropertyIndex
		)
	{
		eDataType=IVariable::DT_SIMPLE;
		// We check for the kind of property we have...
		// ...creating the appropriate variable match and setting the correct
		// data type for it.
		switch (astPropertiesDesc[nCurrentPropertyIndex].propertyType)
		{
		case eAAPT_string:
			{
				poVariable=new CVariable<CString>();
				eDataType=IVariable::DT_ANIMATION;
			}
			break;

		case eAAPT_float:
			{
				poVariable=new CVariable<float>();
			}
			break;

		case eAAPT_int:
			{
				poVariable=new CVariable<int>();
			}
			break;

		case eAAPT_bool:
			{
				poVariable=new CVariable<bool>();
			}
			break;

		default:
			{
				// If this happens, we must update the code.
				poVariable=new CVariable<int>();
				assert(false);
				DebugBreak();
			}
			break;
		}

		assert(rcPropertyValues.size()>nCurrentPropertyIndex);
		poVariable->Set(rcPropertyValues[nCurrentPropertyIndex].GetAsString(&astPropertiesDesc[nCurrentPropertyIndex]).c_str());
		poVariable->SetUserData(piCurrentAnimAction);

		// After we have the correct info for this variable, we add it to the properties control with the appropriate
		// description.
		m_oVarObject.AddVariable(*poVariable,astPropertiesDesc[nCurrentPropertyIndex].propertyName,functor(*this,&CAnimActionEditorPropertiesPanel::OnPropertyChanged),eDataType);
	}

	// After adding all properties (at least one) we bind it to the control and enable it for editing.
	m_poPropertiesPanel->SetVarBlock(m_oVarObject.GetVarBlock());
	m_poPropertiesPanel->EnableWindow(TRUE);
}
//////////////////////////////////////////////////////////////////////////
void CAnimActionEditorPropertiesPanel::DoDataExchange(CDataExchange* pDX)
{
	CXTResizeDialog::DoDataExchange(pDX);
}
//////////////////////////////////////////////////////////////////////////
BOOL CAnimActionEditorPropertiesPanel::OnInitDialog()
{
	BOOL bnReturnValue=__super::OnInitDialog();

	CRect rc(0,0,200,1100);
	m_wndTaskPanel.Create( WS_CHILD|WS_BORDER|WS_VISIBLE|WS_CLIPSIBLINGS|WS_CLIPCHILDREN,rc,this,eTaskPanel );
	m_wndTaskPanel.SetBehaviour(xtpTaskPanelBehaviourExplorer);
	m_wndTaskPanel.SetTheme(xtpTaskPanelThemeNativeWinXP);
	m_wndTaskPanel.SetSelectItemOnFocus(TRUE);
	m_wndTaskPanel.AllowDrag(TRUE);
	m_wndTaskPanel.SetAnimation(xtpTaskPanelAnimationNo);

	m_poPropertiesPanel=new CPropertiesPanel(&m_wndTaskPanel);
	m_poPropertiesPanel->ShowWindow(SW_SHOW);

	return bnReturnValue;
}
//////////////////////////////////////////////////////////////////////////
void CAnimActionEditorPropertiesPanel::OnClose()
{
	DestroyWindow();
}
//////////////////////////////////////////////////////////////////////////
LRESULT CAnimActionEditorPropertiesPanel::OnTaskPanelNotify( WPARAM wParam, LPARAM lParam )
{
	switch(wParam) 
	{
	case XTP_TPN_CLICK:
		{
			CXTPTaskPanelGroupItem* pItem = (CXTPTaskPanelGroupItem*)lParam;
			UINT nCmdID = pItem->GetID();
			//switch (nCmdID)
			//{
			//case eOpenFolderLink:
			//	{
			//		OnBnClickedTextureBrowserOpenFolderButton();
			//	}
			//	break;

			//case ePreviewLink:
			//	{
			//		OnBnClickedTextureBrowserPreviewButton();
			//	}
			//	break;
			//}
		}
	}
	return 0;
}
//////////////////////////////////////////////////////////////////////////
void	CAnimActionEditorPropertiesPanel::OnPropertyChanged(IVariable*	piVariable)
{
	// Must add here code to save the properties.
	// The properties should be saved here in order to allow us to preview an AnimAction
	// without having to select another one to save it.
	IAnimActionClass*																			piCurrentAnimAction(NULL);
	const SAnimActionPropertyDesc*												astPropertiesDesc(NULL);
	int																										nCurrentPropertyIndex(0);
	string																								strPropertyName(piVariable->GetName());
	CString																								strPropertyValue;

	piCurrentAnimAction=(IAnimActionClass*)piVariable->GetUserData();
	if (!piCurrentAnimAction)
	{
		assert("This should not happen. All properties SHOULD have data associated."&&piCurrentAnimAction);
		return;
	}

	// We are getting the property values as well in order to set the values of the added variables.
	// BUG: currently the values displayed are the ones from the first AnimAction selected only.
	// It should check with all variables those who have the same value and only set those.
	TAnimActionPropertyValues&		rcPropertyValues=piCurrentAnimAction->GetProperties();

	// We will be using the properties description for displaying the properties properly in the
	// properties control.
	astPropertiesDesc=piCurrentAnimAction->GetPropertiesDesc();

	// In this case we have no property descriptors at all...(which means we don't have properties as well)
	if (!astPropertiesDesc)
	{
		//... we still can't add properties here as we don't actually have them...
		return;
	}

	// For all valid descriptors (before the null descriptor is found)...
	for (
		nCurrentPropertyIndex=0;
		astPropertiesDesc[nCurrentPropertyIndex].propertyType!=eAAPT_null;
	++nCurrentPropertyIndex
		)
	{
		if (strPropertyName.compare(astPropertiesDesc[nCurrentPropertyIndex].propertyName)==0)
		{
			piVariable->Get(strPropertyValue);
			rcPropertyValues[nCurrentPropertyIndex].SetAsString(&astPropertiesDesc[nCurrentPropertyIndex],strPropertyValue.GetBuffer());
		}
	}


	CEditorAnimActionManager::GetAnimActionManager().SavePrototype(piCurrentAnimAction);
}
//////////////////////////////////////////////////////////////////////////
